/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: pgpSECSHPriv.h,v 1.5 2001/03/20 00:05:15 hal Exp $
____________________________________________________________________________*/
#ifndef Included_pgpSECSHPriv_h	/* [ */
#define Included_pgpSECSHPriv_h

#include "pgpSECSH.h"
#include "pgpMemoryMgr.h"
#include "pgpPublicKey.h"

#define	kPGPsecsh_MajorVersion				1
#define	kPGPsecsh_MinorVersion				5

#define	kPGPsecsh_MaximumPacketSize			32768
#define	kPGPsecsh_MaximumIDStringSize		512
#define	kPGPsecsh_RecordLengthSize			4
#define	kPGPsecsh_CRCSize					4
#define	kPGPsecsh_CookieSize				8
#define	kPGPsecsh_SessionIDSize				16
#define	kPGPsecsh_SessionKeySize			32


/* Cipher Types */
#define kPGPsecsh_CT_None					0
#define kPGPsecsh_CT_IDEA					1
#define kPGPsecsh_CT_DES					2
#define kPGPsecsh_CT_3DES					3
#define kPGPsecsh_CT_TSS					4
#define kPGPsecsh_CT_RC4					5

/* Authentication/Identification Types */
#define kPGPsecsh_IT_RHosts					1
#define kPGPsecsh_IT_RSA					2
#define kPGPsecsh_IT_Password				3
#define kPGPsecsh_IT_RHostsRSA				4

/* Alert Levels */
#define	kPGPsecsh_AL_WarningAlert			1
#define	kPGPsecsh_AL_FatalAlert				2


/* Internal Events */
#define	kPGPsecsh_EV_ReceiveSuccess			0
#define kPGPsecsh_EV_ReceiveFailure			1
#define kPGPsecsh_EV_ReceiveServerPublicKey	2
#define kPGPsecsh_EV_ReceiveRSAChallenge	3
#define kPGPsecsh_EV_ReceiveDebug			4
#define kPGPsecsh_EV_ReceiveUnknownPacket	5



typedef struct PGPsecshContextPriv
{
	PGPContextRef			pgpContext;

} PGPsecshContextPriv;

typedef struct PGPsecshSessionPriv
{
	PGPsecshProtocolState	state;
	PGPInt8					intState;
	PGPContextRef			pgpContext;
	PGPsecshContextPriv		*secshContext;
	PGPMemoryMgrRef			memMgr;
	
	PGPsecshReceiveProcPtr	secshReceiveProc;
	PGPsecshSendProcPtr		secshSendProc;
	void *					secshReceiveUserData;
	void *					secshSendUserData;
		
	PGPBoolean				isClientSide;
	PGPBoolean				blocking;
	PGPUInt32				remoteProtocolFlags;
	PGPUInt32				localProtocolFlags;
	PGPUInt32				cipherMask;
	PGPUInt32				authMask;
	
	char *					userName;
	char *					hostName;

	PGPKeyDBObjRef			localKey;
	char *					localKeyPassphrase;
	PGPByte *				localKeyPasskeyBuffer;
	PGPSize					localKeyPasskeySize;
	PGPBoolean				localKeyUsePasskey;
	PGPPrivateKeyContextRef	localKeyContext;
	PGPKeyDBRef				remoteHostKeyDB;
	PGPKeyDBRef				remoteServerKeyDB;
	PGPKeyDBObjRef			remoteHostKey;
	PGPKeyDBObjRef			remoteServerKey;
	PGPKeySetRef			remoteHostLookupKeyset;
	PGPPublicKeyContextRef	remoteHostKeyContext;
	PGPPublicKeyContextRef	remoteServerKeyContext;
	
	PGPByte					cookie[kPGPsecsh_CookieSize];
	PGPByte					sessionID[kPGPsecsh_SessionIDSize];
	PGPBoolean				encrypting;
	
	PGPCBCContextRef		writeCipherCBC;
	PGPCBCContextRef		readCipherCBC;
	PGPCFBContextRef		writeCipherCFB;
	PGPCFBContextRef		readCipherCFB;
	
	PGPByte	*				queuedSendData;
	PGPSize					queuedSendSize;
	PGPByte *				rcvdRawData;
	PGPSize					rawDataSize;
	
	PGPsecshAlert			fatalAlert;
} PGPsecshSessionPriv;


PGPError pgpSECSHReceivePacket( PGPsecshSessionPriv *	session,
						PGPByte *			outType,
						PGPByte **			outBuffer,
						PGPSize *			outLength );
PGPError pgpSECSHSendPacket( PGPsecshSessionPriv *	session,
						PGPByte				pktType,
						const PGPByte *		inBuffer,
						PGPSize				inLength );

PGPError pgpSECSHBufferRawData( PGPsecshSessionPriv *	session,
						const PGPByte *		rawData,
						PGPSize				rawDataSize );
PGPError pgpSECSHExtractRawData( PGPsecshSessionPriv *	session,
						PGPByte *			rawData,
						PGPSize *			rawDataSize );
PGPError pgpSECSHSendRawData( PGPsecshSessionPriv *	session,
						const PGPByte *		inBuffer,
						PGPSize				inLength );
PGPError pgpSECSHBufferSendData( PGPsecshSessionPriv *	session,
						const PGPByte *		sendData,
						PGPSize				sendDataSize );
PGPError pgpSECSHSendSessionKey( PGPsecshSessionPriv *	session);
PGPError pgpSECSHSendUserName( PGPsecshSessionPriv *	session);
PGPError pgpSECSHSendRSAChallengeRequest( PGPsecshSessionPriv *	session);
PGPError pgpSECSHSendRSAResponse( PGPsecshSessionPriv *		session,
						const PGPByte *		inChallenge,
						PGPSize				inLength );
PGPError pgpSECSHSendQueueIdleInternal( PGPsecshSessionPriv *	session );

PGPError pgpSECSHReceiveServerVersion( PGPsecshSessionPriv *	session,
						PGPByte *			outMajor,
						PGPByte *			outMinor );
PGPError pgpSECSHReceivePublicKey( PGPsecshSessionPriv *		session,
						const PGPByte *		inBuffer,
						PGPSize				inLength );
PGPError pgpSECSHReceiveRSAChallenge( PGPsecshSessionPriv *		session,
						const PGPByte *		inBuffer,
						PGPSize				inLength );
PGPError pgpSECSHReceiveSuccessFail( PGPsecshSessionPriv *		session,
						const PGPByte *		inBuffer,
						PGPSize				inLength );
PGPError pgpSECSHReceiveDebug(PGPsecshSessionPriv *				session,
						const PGPByte *		inBuffer,
						PGPSize				inLength );


PGPError pgpSECSHClientHandshake( PGPsecshSessionPriv *	session );

PGPInt8 pgpSECSHNextState( PGPsecshSessionPriv *	session,
						PGPByte				event );
PGPInt8 pgpSECSHPacketToEvent( PGPByte		packetType );

PGPError pgpSECSHAlert( PGPsecshSessionPriv *	session,
						PGPByte				level,
						PGPsecshAlert		type );

PGPError pgpSECSHClientChooseAlgorithm( PGPsecshSessionPriv *	session,
						PGPCipherAlgorithm *	outCipher );



#endif /* ] Included_pgpSECSHPriv_h */


/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
